uniform sampler2D on;
uniform sampler2D waveW;
uniform sampler2D waveC;
uniform float loopStart;
uniform float loopEnd;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
	vec4 color = vec4(0.0,0.0,0.0,0.0);
	float h0 = texture2D(waveW, vec2(uv.x,0.5)).r;
	float h1 = texture2D(waveW, vec2(uv.x,0.5)).g;
	if (uv.y < h0 && uv.y > h1)
	{
		color = texture2D(waveC, vec2(uv.x,0.5));
		vec4 sourceTex = texture2D(on, uv.xy);
		float a = max(max(sourceTex.r, sourceTex.g), sourceTex.b);
		color.rgb *= a;
	}
	if (uv.x>=loopStart && uv.x<=loopEnd)
	{
		float mult = max((uv.y-0.5)*2.0, ((1.0-uv.y)-0.5)*2.0);
		vec3 c = vec3(0.6, 0.6, 0.6);
		vec4 sourceTex = texture2D(on, uv.xy);
		float a = max(max(sourceTex.r, sourceTex.g), sourceTex.b);
		color.rgb = max(color.rgb, mult*c*a);
		color.a = 1.0;
	}
	gl_FragColor = color;
}
